/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import org.kabeja.dxf.helpers.ParametricLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;

public class HatchLineSegment {
    protected Point startPoint;
    protected Vector direction;
    protected double angle;
    protected double totalLength;
    protected double length;
    protected double currentLength;
    protected double[] pattern;
    protected double l;
    protected int index;
    protected ParametricLine line;

    public HatchLineSegment(Point startPoint, double angle, double length) {
        this.startPoint = startPoint;
        this.angle = Math.toRadians(angle);
        this.totalLength = length;
    }

    public HatchLineSegment(Point startPoint, Vector direction, double length) {
        this.startPoint = startPoint;
        this.direction = direction;
        this.totalLength = length;
    }

    public HatchLineSegment(ParametricLine line, double length, double startLength, double[] pattern) {
        this.startPoint = line.getStartPoint();
        this.angle = Math.toRadians(this.angle);
        this.totalLength = length;
        this.currentLength = startLength;
        this.pattern = pattern;
        this.line = line;
        this.initialize(startLength);
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public double getLength() {
        return this.totalLength;
    }

    public Point getPoint(double offset) {
        Point p = new Point();
        p.setX(this.startPoint.getX() + Math.cos(this.angle) * this.totalLength);
        p.setY(this.startPoint.getY() + Math.sin(this.angle) * this.totalLength);
        return p;
    }

    public Point getPointAt(double para) {
        return this.line.getPointAt(para);
    }

    public boolean hasNext() {
        return this.length <= this.totalLength;
    }

    public double next() {
        double l = this.currentLength;
        this.length += Math.abs(this.currentLength);
        if (this.index == this.pattern.length) {
            this.index = 0;
        }
        this.currentLength = this.pattern[this.index];
        ++this.index;
        return l;
    }

    protected void initialize(double startLength) {
        double l = 0.0;
        for (int i = 0; i < this.pattern.length; ++i) {
            if (!((l += Math.abs(this.pattern[i])) > startLength)) continue;
            this.currentLength = l - startLength;
            if (this.pattern[i] < 0.0) {
                this.currentLength *= -1.0;
            }
            this.index = i + 1;
            return;
        }
    }

    public boolean isSolid() {
        return this.pattern.length == 0;
    }
}

