/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFHatch;
import org.kabeja.dxf.helpers.HatchLineFamily;
import org.kabeja.dxf.helpers.HatchLineSegment;
import org.kabeja.dxf.helpers.ParametricLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class HatchLineIterator
implements Iterator {
    public static final double LIMIT = 1.0E-5;
    protected double angle;
    protected Bounds hatchBounds;
    protected HatchLineFamily pattern;
    protected double length;
    protected Vector v;
    protected Vector r;
    protected List bounderyEdges;
    protected ParametricLine patternLine;
    protected double tmin = Double.POSITIVE_INFINITY;
    protected double tmax = Double.NEGATIVE_INFINITY;
    protected double walkingLength;
    protected double currentWalkingStep = 0.0;

    public HatchLineIterator(DXFHatch hatch, HatchLineFamily pattern) {
        this.angle = Math.toRadians(pattern.getRotationAngle());
        this.hatchBounds = hatch.getBounds();
        this.length = pattern.getLength();
        this.bounderyEdges = new ArrayList();
        Point start = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY(), 0.0);
        Point end = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(start, MathUtils.getVector(start, end)));
        start = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY(), 0.0);
        end = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(start, MathUtils.getVector(start, end)));
        start = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY(), 0.0);
        end = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(start, MathUtils.getVector(start, end)));
        start = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY(), 0.0);
        end = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(start, MathUtils.getVector(start, end)));
        this.pattern = pattern;
        this.initialize();
    }

    public boolean hasNext() {
        return this.currentWalkingStep <= this.walkingLength;
    }

    protected void initialize() {
        if (this.length == 0.0) {
            this.length = 1.0;
        }
        Point center = new Point();
        center.setX(this.hatchBounds.getMinimumX() + this.hatchBounds.getWidth() / 2.0);
        center.setY(this.hatchBounds.getMinimumY() + this.hatchBounds.getHeight() / 2.0);
        center.setZ(0.0);
        this.r = new Vector();
        if (Math.abs(this.pattern.getOffsetY()) < 1.0E-5) {
            this.r.setY(0.0);
        } else {
            this.r.setY(this.pattern.getOffsetY());
        }
        if (Math.abs(this.pattern.getOffsetX()) < 1.0E-5) {
            this.r.setX(0.0);
        } else {
            this.r.setX(this.pattern.getOffsetX());
        }
        this.v = new Vector();
        this.v.setX(this.length * Math.cos(this.angle));
        this.v.setY(this.length * Math.sin(this.angle));
        if (Math.abs(this.v.getX()) < 1.0E-5) {
            this.v.setX(0.0);
        }
        if (Math.abs(this.v.getY()) < 1.0E-5) {
            this.v.setY(0.0);
        }
        double[] para = this.getRasterValues(center.getX(), center.getY());
        center = this.getPoint(Math.round(para[0]), Math.round(para[1]));
        this.patternLine = new ParametricLine(center, this.r);
        this.calculateIntersection(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY());
        this.calculateIntersection(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY());
        this.calculateIntersection(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY());
        this.calculateIntersection(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY());
        this.tmin = Math.floor(this.tmin);
        this.tmax = Math.ceil(this.tmax);
        Point p = this.patternLine.getPointAt(this.tmin);
        this.patternLine.setStartPoint(p);
        this.walkingLength = Math.ceil(Math.abs(this.tmax - this.tmin));
    }

    protected void calculateIntersection(double x, double y) {
        Point s = new Point(x, y, 0.0);
        ParametricLine line = new ParametricLine(s, this.v);
        double t = this.patternLine.getIntersectionParameter(line);
        if (t < this.tmin) {
            this.tmin = t;
        }
        if (t > this.tmax) {
            this.tmax = t;
        }
    }

    protected double[] getRasterValues(double x, double y) {
        double[] v = new double[2];
        if (this.r.getX() == 0.0) {
            v[0] = (x - this.pattern.getBaseX()) / this.v.getX();
            v[1] = (y - this.pattern.getBaseY() - this.v.getY() * v[0]) / this.r.getY();
        } else if (this.r.getY() == 0.0) {
            v[0] = (y - this.pattern.getBaseY()) / this.v.getY();
            v[1] = (x - this.pattern.getBaseX()) / this.r.getX();
        } else if (this.v.getX() == 0.0) {
            v[1] = (x - this.pattern.getBaseX()) / this.r.getX();
            v[0] = (y - this.pattern.getBaseY() - this.r.getY() * v[1]) / this.v.getY();
        } else if (this.v.getY() == 0.0) {
            v[1] = (y - this.pattern.getBaseY()) / this.r.getY();
            v[0] = (x - this.pattern.getBaseX() - this.r.getX() * v[1]) / this.v.getX();
        } else {
            double a = this.r.getY() / this.r.getX();
            v[0] = (y - this.pattern.getBaseY() - x * a + this.pattern.getBaseX() * a) / (this.v.getY() - a * this.v.getX());
            v[1] = (x - this.pattern.getBaseX() - this.v.getX() * v[0]) / this.r.getX();
        }
        return v;
    }

    public Object next() {
        Point p = this.patternLine.getPointAt(this.currentWalkingStep);
        ParametricLine line = new ParametricLine(p, this.v);
        Iterator i = this.bounderyEdges.iterator();
        ArrayList<Point> points = new ArrayList<Point>();
        while (i.hasNext()) {
            ParametricLine edge = (ParametricLine)i.next();
            double t = edge.getIntersectionParameter(line);
            if (!(t >= 0.0) || !(t < 1.0)) continue;
            points.add(edge.getPointAt(t));
        }
        double startL = 0.0;
        double l = 0.0;
        if (points.size() == 2) {
            Point start = (Point)points.get(0);
            double startT = line.getParameter(start);
            Point end = (Point)points.get(1);
            double endT = line.getParameter(end);
            startL = 0.0;
            if (startT > endT) {
                line.setStartPoint(end);
                startL = Math.abs(endT - Math.floor(endT)) * this.length;
            } else {
                line.setStartPoint(start);
                startL = Math.abs(startT - Math.floor(startT)) * this.length;
            }
            l = Math.abs(endT - startT) * this.length;
        }
        line.setDirectionVector(MathUtils.normalize(this.v));
        HatchLineSegment segment = new HatchLineSegment(line, l, startL, this.pattern.getPattern());
        this.currentWalkingStep += 1.0;
        return segment;
    }

    public void remove() {
    }

    protected Point getPoint(double m, double n) {
        Point p = new Point();
        p.setX(n * this.r.getX() + this.pattern.getBaseX() + this.v.getX() * m);
        p.setY(n * this.r.getY() + this.pattern.getBaseY() + this.v.getY() * m);
        return p;
    }
}

