/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class DXFUtils {
    public static double distance(Point start, Point end) {
        double length = Math.sqrt(Math.pow(end.getX() - start.getX(), 2.0) + Math.pow(end.getY() - start.getY(), 2.0));
        return length;
    }

    public static double rotateAngleX(Point start, Point end) {
        if (end.getY() == start.getY()) {
            return 0.0;
        }
        double dx = end.getX() - start.getX();
        double dy = end.getY() - start.getY();
        return Math.toDegrees(Math.atan(1.0 / (dy / dx)));
    }

    public static double vectorValue(double[] x) {
        double v = 0.0;
        for (int i = 0; i < x.length; ++i) {
            v += x[i] * x[i];
        }
        return Math.sqrt(v);
    }

    public static Point scalePoint(Point p, double scale) {
        Point r = new Point();
        r.setX(p.getX() * scale);
        r.setY(p.getY() * scale);
        r.setZ(p.getZ() * scale);
        return r;
    }

    public static Point getPointFromParameterizedLine(Point basePoint, Vector direction, double parameter) {
        Point r = DXFUtils.scalePoint(direction, parameter);
        r.setX(r.getX() + basePoint.getX());
        r.setY(r.getY() + basePoint.getY());
        r.setZ(r.getZ() + basePoint.getZ());
        return r;
    }

    public static void reverseDXFLine(DXFLine line) {
        Point start = line.getStartPoint();
        line.setStartPoint(line.getEndPoint());
        line.setEndPoint(start);
    }

    public static void reverseDXFPolyline(DXFPolyline pline) {
        int i;
        ArrayList<DXFVertex> list = new ArrayList<DXFVertex>();
        double bulge = 0.0;
        int size = pline.getVertexCount();
        for (i = 0; i < size; ++i) {
            DXFVertex v = pline.getVertex(0);
            double b = v.getBulge();
            if (b != 0.0) {
                v.setBulge(0.0);
            }
            if (bulge != 0.0) {
                v.setBulge(bulge * -1.0);
            }
            bulge = b;
            list.add(v);
            pline.removeVertex(0);
        }
        for (i = 1; i <= size; ++i) {
            pline.addVertex((DXFVertex)list.get(size - i));
        }
    }

    public static double getArcRadius(DXFVertex start, DXFVertex end) {
        double alpha = 4.0 * Math.atan(Math.abs(start.getBulge()));
        double l = MathUtils.distance(start.getPoint(), end.getPoint());
        double r = l / (2.0 * Math.sin(alpha / 2.0));
        return r;
    }

    public static boolean equals(Point p1, Point p2, double radius) {
        return DXFUtils.distance(p1, p2) < radius;
    }
}

