/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;
import org.kabeja.math.ParametricPlane;

public class DXFViewport
extends DXFEntity {
    private String viewportID = "";
    private String plotStyleName = "";
    private Point lowerLeftCorner = new Point();
    private Point upperRightCorner = new Point();
    private Point centerPoint = new Point();
    private Point snapBasePoint = new Point();
    private Point snapSpacingPoint = new Point();
    private Point gridSpacingPoint = new Point();
    private Vector viewDirectionVector = new Vector();
    private Point viewCenterPoint = new Point();
    private Point viewTargetPoint = new Point();
    private Vector ucsOrigin = new Vector();
    private Vector ucsXAxis = new Vector();
    private Vector ucsYAxis = new Vector();
    private int ucsType = 0;
    private int viewportStatus = 0;
    private double ucsElevation = 0.0;
    private boolean useUCS = false;
    private double height;
    private double width;
    private double ratio;
    private double lensLength;
    private double viewHeight;
    private double frontClippingPlane;
    private double backClippingPlane;
    private double twistAngle;
    private double snapAngle;
    private double circleZoom;
    private double fastZoom;
    private boolean snap;
    private boolean grid;
    private boolean active = false;
    private int renderMode;
    private Set frozenLayerSet = new HashSet();

    public double getBackClippingPlane() {
        return this.backClippingPlane;
    }

    public void setBackClippingPlane(double backClippingPlane) {
        this.backClippingPlane = backClippingPlane;
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point centerPoint) {
        this.centerPoint = centerPoint;
    }

    public double getCircleZoom() {
        return this.circleZoom;
    }

    public void setCircleZoom(double circleZoom) {
        this.circleZoom = circleZoom;
    }

    public double getFastZoom() {
        return this.fastZoom;
    }

    public void setFastZoom(double fastZoom) {
        this.fastZoom = fastZoom;
    }

    public double getFrontClippingPlane() {
        return this.frontClippingPlane;
    }

    public void setFrontClippingPlane(double frontClippingPlane) {
        this.frontClippingPlane = frontClippingPlane;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean grid) {
        this.grid = grid;
    }

    public Point getGridSpacingPoint() {
        return this.gridSpacingPoint;
    }

    public void setGridSpacingPoint(Point gridSpacingPoint) {
        this.gridSpacingPoint = gridSpacingPoint;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getLensLength() {
        return this.lensLength;
    }

    public void setLensLength(double lensLength) {
        this.lensLength = lensLength;
    }

    public Point getLowerLeftCorner() {
        return this.lowerLeftCorner;
    }

    public void setLowerLeftCorner(Point lowerLeftCorner) {
        this.lowerLeftCorner = lowerLeftCorner;
    }

    public String getViewportID() {
        return this.viewportID;
    }

    public void setViewportID(String name) {
        this.viewportID = name;
    }

    public double getAspectRatio() {
        return this.ratio;
    }

    public void setAspectRatio(double ratio) {
        this.ratio = ratio;
    }

    public void setTwistAngle(double rotationAngle) {
        this.twistAngle = rotationAngle;
    }

    public boolean isSnap() {
        return this.snap;
    }

    public void setSnap(boolean snap) {
        this.snap = snap;
    }

    public Point getSnapBasePoint() {
        return this.snapBasePoint;
    }

    public void setSnapBasePoint(Point snapBasePoint) {
        this.snapBasePoint = snapBasePoint;
    }

    public Point getUpperRightCorner() {
        return this.upperRightCorner;
    }

    public void setUpperRightCorner(Point upperRightCorner) {
        this.upperRightCorner = upperRightCorner;
    }

    public Vector getViewDirectionVector() {
        return this.viewDirectionVector;
    }

    public void setViewDirectionVector(Vector viewDirectionPoint) {
        this.viewDirectionVector = viewDirectionPoint;
    }

    public Point getViewCenterPoint() {
        return this.viewCenterPoint;
    }

    public void setViewCenterPoint(Point viewTargetPoint) {
        this.viewCenterPoint = viewTargetPoint;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        if (this.viewportStatus > 0) {
            bounds.addToBounds(this.centerPoint.getX() - this.width / 2.0, this.centerPoint.getY() - this.height / 2.0, 0.0);
            bounds.addToBounds(this.centerPoint.getX() + this.width / 2.0, this.centerPoint.getY() + this.height / 2.0, 0.0);
        }
        return bounds;
    }

    public double getLength() {
        return 0.0;
    }

    public String getType() {
        return "VIEWPORT";
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(double viewHeight) {
        this.viewHeight = viewHeight;
    }

    public Vector getUcsOrigin() {
        return this.ucsOrigin;
    }

    public void setUcsOrigin(Vector ucsOrigin) {
        this.ucsOrigin = ucsOrigin;
    }

    public Vector getUcsXAxis() {
        return this.ucsXAxis;
    }

    public void setUcsXAxis(Vector ucsXAxis) {
        this.ucsXAxis = ucsXAxis;
    }

    public Vector getUcsYAxis() {
        return this.ucsYAxis;
    }

    public void setUcsYAxis(Vector ucsYAxis) {
        this.ucsYAxis = ucsYAxis;
    }

    public int getUcsType() {
        return this.ucsType;
    }

    public void setUcsType(int ucsType) {
        this.ucsType = ucsType;
    }

    public double getUcsElevation() {
        return this.ucsElevation;
    }

    public void setUcsElevation(double ucsElevation) {
        this.ucsElevation = ucsElevation;
    }

    public boolean isUseUCS() {
        return this.useUCS;
    }

    public void setUseUCS(boolean useUCS) {
        this.useUCS = useUCS;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public double getSnapAngle() {
        return this.snapAngle;
    }

    public void setSnapAngle(double snapAngle) {
        this.snapAngle = snapAngle;
    }

    public Point getViewTargetPoint() {
        return this.viewTargetPoint;
    }

    public void setViewTargetPoint(Point viewTargetPoint) {
        this.viewTargetPoint = viewTargetPoint;
    }

    public Point getSnapSpacingPoint() {
        return this.snapSpacingPoint;
    }

    public void setSnapSpacingPoint(Point snapSpacingPoint) {
        this.snapSpacingPoint = snapSpacingPoint;
    }

    public String getPlotStyleName() {
        return this.plotStyleName;
    }

    public void setPlotStyleName(String plotStyleName) {
        this.plotStyleName = plotStyleName;
    }

    public int getViewportStatus() {
        return this.viewportStatus;
    }

    public void setViewportStatus(int viewportStatus) {
        this.viewportStatus = viewportStatus;
    }

    public double getTwistAngle() {
        return this.twistAngle;
    }

    public void addFrozenLayer(String layerName) {
        this.frozenLayerSet.add(layerName);
    }

    public boolean isFrozenLayer(String layerName) {
        return this.frozenLayerSet.contains(layerName);
    }

    public Iterator getFrozenLayerIterator() {
        return this.frozenLayerSet.iterator();
    }

    public double getZoomXPFactor() {
        if (this.viewHeight != 0.0) {
            return this.height / this.viewHeight;
        }
        return this.calculateZoomXPFactor();
    }

    public double calculateZoomXPFactor() {
        double c = this.getViewDirectionVector().getLength() * 42.0 / this.lensLength;
        double f = this.width / this.height;
        double b = Math.sqrt(Math.pow(c, 2.0) / (Math.pow(f, 2.0) + 1.0));
        return this.height / b;
    }

    public Bounds getModelspaceViewBounds() {
        double f = this.width / this.height;
        double modelH = this.height / this.getZoomXPFactor() / 2.0;
        double modelW = f * modelH;
        double wf = modelW / modelH;
        Vector directionX = null;
        directionX = this.viewDirectionVector.getX() == 0.0 && this.viewDirectionVector.getY() == 0.0 && this.viewDirectionVector.getZ() == 1.0 ? new Vector(1.0, 0.0, 0.0) : MathUtils.crossProduct(DXFConstants.DEFAULT_Z_AXIS_VECTOR, this.viewDirectionVector);
        ParametricPlane plane = new ParametricPlane(this.viewTargetPoint, directionX, MathUtils.crossProduct(this.viewDirectionVector, directionX), this.viewDirectionVector);
        Bounds bounds = new Bounds();
        Point p = plane.getPoint(this.viewCenterPoint.getX() - modelW, this.viewCenterPoint.getY() - modelH);
        bounds.addToBounds(p);
        p = plane.getPoint(this.viewCenterPoint.getX() + modelW, this.viewCenterPoint.getY() + modelH);
        bounds.addToBounds(p);
        return bounds;
    }
}

