/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPoint;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DXFVertex
extends DXFPoint {
    private double startWidth = 0.0;
    private double endWidth = 0.0;
    private double bulge = 0.0;
    private int polyFaceMeshVertex0;
    private int polyFaceMeshVertex1;
    private int polyFaceMeshVertex2;
    private int polyFaceMeshVertex3;

    public DXFVertex() {
    }

    public DXFVertex(Point p) {
        super(p);
    }

    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
    }

    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
    }

    public Bounds getBounds() {
        return super.getBounds();
    }

    public double getBulge() {
        return this.bulge;
    }

    public void setBulge(double bulge) {
        this.bulge = bulge;
    }

    public String getType() {
        return "VERTEX";
    }

    public boolean isConstantWidth() {
        return this.endWidth == this.startWidth;
    }

    public boolean isCurveFitVertex() {
        return (this.flags & 1) == 1;
    }

    public boolean isTagentUsed() {
        return (this.flags & 2) == 2;
    }

    public boolean is2DSplineControlVertex() {
        return (this.flags & 0x10) == 16;
    }

    public boolean is2DSplineApproximationVertex() {
        return (this.flags & 8) == 8;
    }

    public boolean isPolyFaceMeshVertex() {
        return (this.flags & 0x40) == 64 && (this.flags & 0x80) == 128;
    }

    public boolean isFaceRecord() {
        return this.flags == 128;
    }

    public boolean isMeshApproximationVertex() {
        return (this.flags & 0x40) == 64 && (this.flags & 8) == 8;
    }

    public int getPolyFaceMeshVertex0() {
        return Math.abs(this.polyFaceMeshVertex0);
    }

    public void setPolyFaceMeshVertex0(int polyFaceMeshVertex0) {
        this.polyFaceMeshVertex0 = polyFaceMeshVertex0;
    }

    public int getPolyFaceMeshVertex1() {
        return Math.abs(this.polyFaceMeshVertex1);
    }

    public void setPolyFaceMeshVertex1(int polyFaceMeshVertex1) {
        this.polyFaceMeshVertex1 = polyFaceMeshVertex1;
    }

    public int getPolyFaceMeshVertex2() {
        return Math.abs(this.polyFaceMeshVertex2);
    }

    public void setPolyFaceMeshVertex2(int polyFaceMeshVertex2) {
        this.polyFaceMeshVertex2 = polyFaceMeshVertex2;
    }

    public int getPolyFaceMeshVertex3() {
        return Math.abs(this.polyFaceMeshVertex3);
    }

    public void setPolyFaceMeshVertex3(int polyFaceMeshVertex3) {
        this.polyFaceMeshVertex3 = polyFaceMeshVertex3;
    }

    public boolean isPolyFaceEdge0Visible() {
        return this.polyFaceMeshVertex0 > 0;
    }

    public boolean isPolyFaceEdge1Visible() {
        return this.polyFaceMeshVertex1 > 0;
    }

    public boolean isPolyFaceEdge2Visible() {
        return this.polyFaceMeshVertex2 > 0;
    }

    public boolean isPolyFaceEdge3Visible() {
        return this.polyFaceMeshVertex3 > 0;
    }
}

