/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.DXFTextParser;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.TextDocument;

public class DXFText
extends DXFEntity {
    public static final double DEFAULT_FONT_SIZE = 8.0;
    public static final int VALIGN_BASELINE = 0;
    public static final int VALIGN_BOTTOM = 1;
    public static final int VALIGN_CENTER = 2;
    public static final int VALIGN_TOP = 3;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_ALIGNED = 3;
    public static final int ALIGN_MIDDLE = 4;
    public static final int ALIGN_FIT = 5;
    protected double rotation = 0.0;
    protected double height = 0.0;
    protected double scale_x = 1.0;
    protected double oblique_angle = 0.0;
    protected double align_x = 0.0;
    protected double align_y = 0.0;
    protected double align_z = 0.0;
    protected int align = 0;
    protected int valign = 0;
    protected String text = "";
    protected String textStyle = "";
    protected Point p;
    protected Point align_p1;
    protected Point align_p2;
    protected boolean upsideDown = false;
    protected boolean backward = false;
    protected boolean alignmentPointSet = false;
    protected boolean top = false;
    protected boolean bottom = false;
    protected boolean vertical_center = false;
    protected TextDocument textDoc = new TextDocument();

    public DXFText() {
        this.p = new Point();
        this.align_p1 = new Point();
    }

    public void setDXFDocument(DXFDocument doc) {
        super.setDXFDocument(doc);
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        double tl = this.getTextDocument().getText().length();
        if (tl > 0.0) {
            Point p = this.calculateAlignmentPoint();
            bounds.addToBounds(p);
            double h = this.getHeight();
            double w = tl * h * 0.6;
            if (this.isBackward()) {
                w = -1.0 * w;
            }
            switch (this.align) {
                case 0: {
                    bounds.addToBounds(p.getX() + w, p.getY(), p.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(p.getX() + w / 2.0, p.getY(), p.getZ());
                    bounds.addToBounds(p.getX() - w / 2.0, p.getY(), p.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(p.getX() - w, p.getY(), p.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(p.getX() - w, p.getY(), p.getZ());
                    break;
                }
                case 4: {
                    bounds.addToBounds(p.getX() + w / 2.0, p.getY(), p.getZ());
                    bounds.addToBounds(p.getX() - w / 2.0, p.getY(), p.getZ());
                    break;
                }
                case 5: {
                    bounds.addToBounds(p.getX() + w / 2.0, p.getY(), p.getZ());
                    bounds.addToBounds(p.getX() - w / 2.0, p.getY(), p.getZ());
                }
            }
            switch (this.valign) {
                case 0: {
                    bounds.addToBounds(p.getX(), p.getY() + h * 0.75, p.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(p.getX(), p.getY() + h, p.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(p.getX(), p.getY() + h * 0.5, p.getZ());
                    bounds.addToBounds(p.getX(), p.getY() - h * 0.5, p.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(p.getX(), p.getY() - h, p.getZ());
                }
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public double getAlignX() {
        return this.align_p1.getX();
    }

    public void setAlignX(double align_x) {
        this.align_p1.setX(align_x);
    }

    public double getAlignY() {
        return this.align_p1.getY();
    }

    public void setAlignY(double align_y) {
        this.align_p1.setY(align_y);
    }

    public double getAlignZ() {
        return this.align_p1.getZ();
    }

    public void setAlignZ(double align_z) {
        this.align_p1.setZ(align_z);
    }

    public double getHeight() {
        if (this.height != 0.0) {
            return this.height;
        }
        if (this.doc.getDXFStyle(this.textStyle) != null) {
            return this.doc.getDXFStyle(this.textStyle).getTextHeight();
        }
        return 0.0;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getObliqueAngle() {
        return this.oblique_angle;
    }

    public void setObliqueAngle(double oblique_angle) {
        this.oblique_angle = oblique_angle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double getScaleX() {
        return this.scale_x;
    }

    public void setScaleX(double scale_x) {
        this.scale_x = scale_x;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textDoc = DXFTextParser.parseDXFText(this);
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String textStyle) {
        this.textStyle = textStyle;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public void setX(double x) {
        this.p.setX(x);
    }

    public void setY(double y) {
        this.p.setY(y);
    }

    public void setZ(double z) {
        this.p.setZ(z);
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean backward) {
        this.backward = backward;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    public String getType() {
        return "TEXT";
    }

    public boolean isAlignmentPointSet() {
        return this.alignmentPointSet;
    }

    public void setAlignmentPoint(boolean alignmentPoint) {
        this.alignmentPointSet = alignmentPoint;
    }

    public TextDocument getTextDocument() {
        return this.textDoc;
    }

    public Point getInsertPoint() {
        return this.p;
    }

    public Point getAlignmentPoint() {
        return this.align_p1;
    }

    public Point calculateAlignmentPoint() {
        Point alignmentPoint = new Point(this.p.getX(), this.p.getY(), this.p.getZ());
        if (!this.isUpsideDown()) {
            switch (this.align) {
                case 1: {
                    if (!this.alignmentPointSet) break;
                    alignmentPoint.setX(this.align_p1.getX());
                    break;
                }
                case 2: {
                    if (!this.alignmentPointSet) break;
                    alignmentPoint.setX(this.align_p1.getX());
                    break;
                }
                case 3: {
                    if (!this.alignmentPointSet) break;
                    alignmentPoint.setX(this.align_p1.getX());
                    break;
                }
                case 4: {
                    if (!this.alignmentPointSet) break;
                    alignmentPoint.setX(this.align_p1.getX());
                    break;
                }
                case 5: {
                    if (!this.alignmentPointSet) break;
                    alignmentPoint.setX(this.align_p1.getX());
                }
            }
            if (this.alignmentPointSet) {
                alignmentPoint.setY(this.align_p1.getY());
            }
        }
        return alignmentPoint;
    }

    public boolean isOmitLineType() {
        return true;
    }

    public double getLength() {
        return 0.0;
    }
}

