/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.DXFTextParser;
import org.kabeja.dxf.helpers.TextDocument;

public class DXFMText
extends DXFText {
    public static final int ATTACHMENT_TOP_LEFT = 1;
    public static final int ATTACHMENT_TOP_CENTER = 2;
    public static final int ATTACHMENT_TOP_RIGHT = 3;
    public static final int ATTACHMENT_MIDDLE_LEFT = 4;
    public static final int ATTACHMENT_MIDDLE_CENTER = 5;
    public static final int ATTACHMENT_MIDDLE_RIGHT = 6;
    public static final int ATTACHMENT_BOTTOM_LEFT = 7;
    public static final int ATTACHMENT_BOTTOM_CENTER = 8;
    public static final int ATTACHMENT_BOTTOM_RIGHT = 9;
    private int attachmentpointLocation = 1;
    private double refwidth = 0.0;
    private double refheight = 0.0;

    public void setAttachmentPoint(int value) {
        this.attachmentpointLocation = value;
    }

    public void setReferenceWidth(double width) {
        this.refwidth = width;
    }

    public double getReferenceWidth() {
        return this.refwidth;
    }

    public void setReferenceHeight(double height) {
        this.refheight = height;
    }

    public double getReferenceHeight() {
        return this.refheight;
    }

    public String getType() {
        return "MTEXT";
    }

    public double getRotation() {
        if (this.rotation != 0.0) {
            return this.rotation;
        }
        if (this.align_p1.getX() != 0.0 || this.align_p1.getY() != 0.0 || this.align_p1.getZ() != 0.0) {
            return Math.toDegrees(Math.atan2(this.align_p1.getY(), this.align_p1.getX()));
        }
        return this.rotation;
    }

    public TextDocument getTextDocument() {
        return this.textDoc;
    }

    public void setText(String text) {
        this.text = text;
        this.textDoc = DXFTextParser.parseDXFMText(this);
    }

    public int getAlignment() {
        return this.attachmentpointLocation;
    }

    public boolean isOmitLineType() {
        return true;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        int l = this.textDoc.getMaximumLineLength();
        if (l > 0) {
            double h = this.getHeight();
            if (h == 0.0) {
                h = this.getReferenceHeight();
            }
            double w = (double)l * 0.7 * h;
            h *= (double)this.textDoc.getLineCount();
            switch (this.attachmentpointLocation) {
                case 8: {
                    bounds.addToBounds(this.p.getX() + w / 2.0, this.p.getY() + h, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - w / 2.0, this.p.getY(), this.p.getZ());
                    break;
                }
                case 7: {
                    bounds.addToBounds(this.p.getX() + w, this.p.getY() + h, this.p.getZ());
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    break;
                }
                case 9: {
                    bounds.addToBounds(this.p.getX() - w, this.p.getY() + h, this.p.getZ());
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    break;
                }
                case 5: {
                    bounds.addToBounds(this.p.getX() + w / 2.0, this.p.getY() + h / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - w / 2.0, this.p.getY() - h / 2.0, this.p.getZ());
                    break;
                }
                case 4: {
                    bounds.addToBounds(this.p.getX(), this.p.getY() + h / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() + w, this.p.getY() - h / 2.0, this.p.getZ());
                    break;
                }
                case 6: {
                    bounds.addToBounds(this.p.getX(), this.p.getY() + h / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - w, this.p.getY() - h / 2.0, this.p.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() + w, this.p.getY() - h, this.p.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(this.p.getX() + w / 2.0, this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() - w / 2.0, this.p.getY() - h, this.p.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() - w, this.p.getY() - h, this.p.getZ());
                }
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }
}

