/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.helpers.DXFMLineSegment;
import org.kabeja.dxf.helpers.MLineConverter;
import org.kabeja.dxf.helpers.Point;

public class DXFMLine
extends DXFEntity {
    public static final int JUSTIFICATION_TOP = 0;
    public static final int JUSTIFICATION_ZERO = 1;
    public static final int JUSTIFICATION_BOTTOM = 2;
    protected double scale = 1.0;
    protected Point startPoint = new Point();
    protected List mlineSegments = new ArrayList();
    protected int lineCount = 0;
    protected int justification = 0;
    protected String mLineStyleID = "";
    protected String mLineStyleName = "";

    public Bounds getBounds() {
        Bounds b = new Bounds();
        DXFPolyline[] pl = this.toDXFPolylines();
        for (int i = 0; i < pl.length; ++i) {
            b.addToBounds(pl[i].getBounds());
        }
        return b;
    }

    public String getType() {
        return "MLINE";
    }

    public double getLength() {
        DXFPolyline[] pl = this.toDXFPolylines();
        double l = 0.0;
        for (int i = 0; i < pl.length; ++i) {
            l += pl[i].getLength();
        }
        return l;
    }

    public void addDXFMLineSegement(DXFMLineSegment seg) {
        this.mlineSegments.add(seg);
    }

    public int getDXFMLineSegmentCount() {
        return this.mlineSegments.size();
    }

    public DXFMLineSegment getDXFMLineSegment(int index) {
        return (DXFMLineSegment)this.mlineSegments.get(index);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = startPoint;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public String getMLineStyleID() {
        return this.mLineStyleID;
    }

    public void setMLineStyleID(String lineStyleID) {
        this.mLineStyleID = lineStyleID;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setJustification(int justification) {
        this.justification = justification;
    }

    public String getMLineStyleName() {
        return this.mLineStyleName;
    }

    public void setMLineStyleName(String lineStyleName) {
        this.mLineStyleName = lineStyleName;
    }

    protected DXFPolyline[] toDXFPolylines() {
        return MLineConverter.toDXFPolyline(this);
    }

    public boolean isClosed() {
        return (this.flags & 2) == 2;
    }
}

