/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;

public class DXFInsert
extends DXFEntity {
    private Point insertPoint = new Point();
    private double scale_x = 1.0;
    private double scale_y = 1.0;
    private double scale_z = 1.0;
    private double rotate = 0.0;
    private int rows = 1;
    private int columns = 1;
    private double row_spacing = 0.0;
    private double column_spacing = 0.0;
    private String blockID = "";

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        DXFBlock block = this.doc.getDXFBlock(this.getBlockID());
        Bounds b = block.getBounds();
        if (!b.isValid()) {
            bounds.setValid(false);
            return bounds;
        }
        Point blkPoint = block.getReferencePoint();
        bounds.setMaximumX((b.getMaximumX() - blkPoint.getX()) * this.scale_x);
        bounds.setMinimumX((b.getMinimumX() - blkPoint.getX()) * this.scale_x);
        bounds.setMaximumY((b.getMaximumY() - blkPoint.getY()) * this.scale_y);
        bounds.setMinimumY((b.getMinimumY() - blkPoint.getY()) * this.scale_y);
        if (this.rotate != 0.0) {
            Point p1 = this.rotatePoint(bounds.getMaximumX(), bounds.getMaximumY());
            Point p2 = this.rotatePoint(bounds.getMaximumX(), bounds.getMinimumY());
            Point p3 = this.rotatePoint(bounds.getMinimumX(), bounds.getMaximumY());
            Point p4 = this.rotatePoint(bounds.getMinimumX(), bounds.getMinimumY());
            bounds = new Bounds();
            bounds.addToBounds(p1);
            bounds.addToBounds(p2);
            bounds.addToBounds(p3);
            bounds.addToBounds(p4);
        }
        bounds.setMaximumX(bounds.getMaximumX() + this.insertPoint.getX());
        bounds.setMinimumX(bounds.getMinimumX() + this.insertPoint.getX());
        bounds.setMaximumY(bounds.getMaximumY() + this.insertPoint.getY());
        bounds.setMinimumY(bounds.getMinimumY() + this.insertPoint.getY());
        double width = (double)(this.columns - 1) * this.column_spacing;
        double height = (double)(this.rows - 1) * this.row_spacing;
        if (width >= 0.0) {
            bounds.setMinimumX(bounds.getMinimumX() - width);
        } else {
            bounds.setMaximumX(bounds.getMaximumX() - width);
        }
        if (height >= 0.0) {
            bounds.setMinimumY(bounds.getMinimumY() - height);
        } else {
            bounds.setMaximumY(bounds.getMaximumY() - height);
        }
        return bounds;
    }

    public String getBlockID() {
        return this.blockID;
    }

    public void setBlockID(String blockID) {
        this.blockID = blockID;
    }

    public double getColumnSpacing() {
        return this.column_spacing;
    }

    public void setColumnSpacing(double column_spacing) {
        this.column_spacing = column_spacing;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public Point getPoint() {
        return this.insertPoint;
    }

    public void setPoint(Point p) {
        this.insertPoint = p;
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public double getRowSpacing() {
        return this.row_spacing;
    }

    public void setRowSpacing(double row_spacing) {
        this.row_spacing = row_spacing;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public double getScaleX() {
        return this.scale_x;
    }

    public void setScaleX(double scale_x) {
        this.scale_x = scale_x;
    }

    public double getScaleY() {
        return this.scale_y;
    }

    public void setScaleY(double scale_y) {
        this.scale_y = scale_y;
    }

    public double getScaleZ() {
        return this.scale_z;
    }

    public void setScaleZ(double scale_z) {
        this.scale_z = scale_z;
    }

    private Point rotatePoint(double x, double y) {
        double phi = Math.toRadians(this.rotate);
        Point point = new Point();
        point.setX(x * Math.cos(phi) - y * Math.sin(phi));
        point.setY(x * Math.sin(phi) + y * Math.cos(phi));
        return point;
    }

    public String getType() {
        return "INSERT";
    }

    public double getLength() {
        return this.doc.getDXFBlock(this.blockID).getLength();
    }
}

