/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.objects.DXFImageDefObject;

public class DXFImage
extends DXFEntity {
    protected Point insertPoint = new Point();
    protected Point vectorV = new Point();
    protected Point vectorU = new Point();
    protected double imageSizeAlongU;
    protected double imageSizeAlongV;
    protected String imageDefID = "";
    protected double brightness;
    protected double contrast;
    protected double fade;
    protected ArrayList clipBoundary = new ArrayList();
    protected boolean clipping = false;
    protected boolean rectangularClipping = false;
    protected boolean polygonalClipping = false;

    public Bounds getBounds() {
        Bounds b = new Bounds();
        DXFImageDefObject imageDef = (DXFImageDefObject)this.doc.getDXFObjectByID(this.getImageDefObjectID());
        if (imageDef != null) {
            b.addToBounds(this.insertPoint);
            b.addToBounds(this.insertPoint.getX() + this.imageSizeAlongU, this.insertPoint.getY() + this.imageSizeAlongV, this.insertPoint.getZ());
        } else {
            b.setValid(false);
        }
        return b;
    }

    public String getType() {
        return "IMAGE";
    }

    public Point getInsertPoint() {
        return this.insertPoint;
    }

    public void setInsertPoint(Point p) {
        this.insertPoint = p;
    }

    public void setImageDefObjectID(String id) {
        this.imageDefID = id;
    }

    public String getImageDefObjectID() {
        return this.imageDefID;
    }

    public double getImageSizeAlongU() {
        return this.imageSizeAlongU;
    }

    public void setImageSizeAlongU(double imageSizeAlongU) {
        this.imageSizeAlongU = imageSizeAlongU;
    }

    public double getImageSizeAlongV() {
        return this.imageSizeAlongV;
    }

    public void setImageSizeAlongV(double imageSizeAlongV) {
        this.imageSizeAlongV = imageSizeAlongV;
    }

    public Point getVectorU() {
        return this.vectorU;
    }

    public void setVectorU(Point vectorU) {
        this.vectorU = vectorU;
    }

    public Point getVectorV() {
        return this.vectorV;
    }

    public void setVectorV(Point vectorV) {
        this.vectorV = vectorV;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double brightness) {
        this.brightness = brightness;
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean clipping) {
        this.clipping = clipping;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setContrast(double contrast) {
        this.contrast = contrast;
    }

    public double getFade() {
        return this.fade;
    }

    public void setFade(double fade) {
        this.fade = fade;
    }

    public ArrayList getClipBoundary() {
        return this.clipBoundary;
    }

    public void addClippingPoint(Point p) {
        this.clipBoundary.add(p);
    }

    public boolean isPolygonalClipping() {
        return this.polygonalClipping;
    }

    public void setPolygonalClipping(boolean polygonalClipping) {
        this.polygonalClipping = polygonalClipping;
        this.rectangularClipping = !polygonalClipping;
    }

    public boolean isRectangularClipping() {
        return this.rectangularClipping;
    }

    public void setRectangularClipping(boolean rectangularClipping) {
        this.rectangularClipping = rectangularClipping;
        this.polygonalClipping = !rectangularClipping;
    }

    public double getLength() {
        return 0.0;
    }
}

