/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class DXFExtrusion {
    private static final double v = 0.015625;
    protected Vector n = new Vector(0.0, 0.0, 1.0);
    protected Vector x;
    protected Vector y;

    public double getX() {
        return this.n.getX();
    }

    public void setX(double x) {
        this.n.setX(x);
    }

    public double getY() {
        return this.n.getY();
    }

    public void setY(double y) {
        this.n.setY(y);
    }

    public double getZ() {
        return this.n.getZ();
    }

    public void setZ(double z) {
        this.n.setZ(z);
    }

    public Vector getDirectionX() {
        if (Math.abs(this.n.getX()) < 0.015625 && Math.abs(this.n.getY()) < 0.015625) {
            return MathUtils.crossProduct(DXFConstants.DEFAULT_Y_AXIS_VECTOR, this.n);
        }
        return MathUtils.crossProduct(DXFConstants.DEFAULT_Z_AXIS_VECTOR, this.n);
    }

    public Vector getDirectionY() {
        return MathUtils.crossProduct(this.n, this.getDirectionX());
    }

    public Point extrudePoint(Point basePoint, double elevation) {
        return MathUtils.getPointOfStraightLine(basePoint, this.n, elevation);
    }

    public Vector getNormal() {
        return this.n;
    }

    public Vector getDirectionZ() {
        return this.n;
    }
}

