/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;
import org.kabeja.math.ParametricPlane;

public class DXFEllipse
extends DXFEntity {
    public static final double DEFAULT_END_PARAMETER = Math.PI * 2;
    public static final double DEFAULT_START_PARAMETER = 0.0;
    public static final int INTEGRATION_STEPS = 15;
    private double ratio = 1.0;
    private double startParameter = 0.0;
    private double endParameter = Math.PI * 2;
    private Point center = new Point();
    private Vector majorAxisDirection = new Vector();
    private boolean counterclockwise;

    public DXFEllipse() {
        this.center = new Point();
    }

    public Bounds getBounds() {
        double alpha = this.getRotationAngle();
        Bounds bounds = new Bounds();
        ParametricPlane plane = new ParametricPlane(this.center, this.getExtrusion().getDirectionX(), this.getExtrusion().getDirectionY(), this.getExtrusion().getNormal());
        if (this.startParameter == 0.0 && this.endParameter == Math.PI * 2 && alpha == 0.0) {
            double length = this.getHalfMajorAxisLength();
            bounds.addToBounds(plane.getPoint(length, length));
            bounds.addToBounds(plane.getPoint(-length, -length));
        } else {
            int n = 40;
            double h = (this.endParameter - this.startParameter) / (double)n;
            double start = this.startParameter;
            double major = this.getHalfMajorAxisLength();
            double minor = major * this.ratio;
            Vector minorAxis = MathUtils.crossProduct(this.getExtrusion().getNormal(), this.getMajorAxisDirection());
            minorAxis = MathUtils.scaleVector(minorAxis, this.ratio);
            for (int i = 0; i <= n; ++i) {
                Vector v1 = MathUtils.scaleVector(this.getMajorAxisDirection(), Math.cos(start));
                Vector v2 = MathUtils.scaleVector(minorAxis, Math.sin(start));
                double x = v1.getX() + v2.getX();
                double y = v1.getY() + v2.getY();
                Point p = plane.getPoint(x, y);
                bounds.addToBounds(p);
                start += h;
            }
        }
        return bounds;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public void setCenterPoint(Point center) {
        this.center = center;
    }

    public Vector getMajorAxisDirection() {
        return this.majorAxisDirection;
    }

    public void setMajorAxisDirection(Vector d) {
        this.majorAxisDirection = d;
    }

    public double getEndParameter() {
        return this.endParameter;
    }

    public void setEndParameter(double endParameter) {
        this.endParameter = endParameter < 0.0 ? Math.PI * 2 + endParameter : endParameter;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(double startParameter) {
        this.startParameter = startParameter < 0.0 ? Math.PI * 2 + startParameter : startParameter;
    }

    public String getType() {
        return "ELLIPSE";
    }

    public double getHalfMajorAxisLength() {
        return this.majorAxisDirection.getLength();
    }

    public Point getLocalPointAt(double para) {
        Point p = new Point();
        double major = this.getHalfMajorAxisLength();
        double minor = major * this.ratio;
        double x = major * Math.cos(para);
        double y = minor * Math.sin(para);
        double alpha = this.getRotationAngle();
        if (alpha != 0.0) {
            double lx = x;
            x = lx * Math.cos(alpha) - y * Math.sin(alpha);
            y = lx * Math.sin(alpha) + y * Math.cos(alpha);
        }
        p.setX(x);
        p.setY(y);
        p.setZ(0.0);
        return p;
    }

    public Point getPointAt(double para) {
        ParametricPlane plane = new ParametricPlane(this.center, this.getExtrusion().getDirectionX(), this.getExtrusion().getDirectionY(), this.getExtrusion().getNormal());
        Vector minorAxis = MathUtils.crossProduct(this.getExtrusion().getNormal(), this.getMajorAxisDirection());
        minorAxis = MathUtils.scaleVector(minorAxis, this.ratio);
        Vector v1 = MathUtils.scaleVector(this.getMajorAxisDirection(), Math.cos(para));
        Vector v2 = MathUtils.scaleVector(minorAxis, Math.sin(para));
        double x = v1.getX() + v2.getX();
        double y = v1.getY() + v2.getY();
        Point p = plane.getPoint(x, y);
        return p;
    }

    public Point getLocalStartPoint() {
        return this.getLocalPointAt(this.startParameter);
    }

    public Point getLocalEndPoint() {
        return this.getLocalPointAt(this.endParameter);
    }

    public double getRotationAngle() {
        return MathUtils.getAngle(DXFConstants.DEFAULT_X_AXIS_VECTOR, this.majorAxisDirection);
    }

    public double getLength() {
        int n = 15;
        double h = (this.endParameter - this.startParameter) / (double)n;
        double a = this.getHalfMajorAxisLength();
        double b = a * this.ratio;
        double start = this.startParameter;
        double end = 0.0;
        double length = 0.0;
        for (int i = 0; i < n; ++i) {
            double center = h / 2.0 + start;
            end = start + h;
            double w1 = Math.sqrt(Math.pow(a * Math.sin(start), 2.0) + Math.pow(b * Math.cos(start), 2.0));
            double w2 = Math.sqrt(Math.pow(a * Math.sin(center), 2.0) + Math.pow(b * Math.cos(center), 2.0));
            double w3 = Math.sqrt(Math.pow(a * Math.sin(end), 2.0) + Math.pow(b * Math.cos(end), 2.0));
            length += (w1 + 4.0 * w2 + w3) * (h / 6.0);
            start = end;
        }
        return length;
    }

    public boolean isCounterClockwise() {
        return this.counterclockwise;
    }

    public void setCounterClockwise(boolean counterclockwise) {
        this.counterclockwise = counterclockwise;
    }
}

