/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.ParametricPlane;

public class DXFCircle
extends DXFEntity {
    private Point center;
    private double radius;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setCenterPoint(Point p) {
        this.center = p;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        ParametricPlane plane = new ParametricPlane(this.getExtrusion());
        Point p = plane.getPoint(this.center.getX(), this.center.getY());
        bounds.setMaximumX(p.getX() + this.radius);
        bounds.setMinimumX(p.getX() - this.radius);
        bounds.setMaximumY(p.getY() + this.radius);
        bounds.setMinimumY(p.getY() - this.radius);
        return bounds;
    }

    public String getType() {
        return "CIRCLE";
    }

    public double getLength() {
        return Math.PI * 2 * this.radius;
    }

    public Point getPointAt(double angle) {
        double x = this.radius * Math.cos(Math.toRadians(angle));
        double y = this.radius * Math.sin(Math.toRadians(angle));
        ParametricPlane plane = new ParametricPlane(this.getExtrusion());
        Point p = plane.getPoint(x + this.center.getX(), y + this.center.getY());
        return p;
    }
}

