/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.MathUtils;
import org.kabeja.math.ParametricPlane;

public class DXFArc
extends DXFEntity {
    private Point center = new Point();
    private double radius;
    private double start_angle;
    private double end_angle;
    private boolean counterclockwise = false;

    public double getEndAngle() {
        return this.end_angle;
    }

    public void setEndAngle(double end_angle) {
        this.end_angle = end_angle;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getStartAngle() {
        return this.start_angle;
    }

    public void setStartAngle(double start_angle) {
        this.start_angle = start_angle;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        bounds.addToBounds(start);
        bounds.addToBounds(end);
        ParametricPlane plane = new ParametricPlane(this.getExtrusion());
        Point center = plane.getPoint(this.center.getX(), this.center.getY());
        int startQ = MathUtils.getQuadrant(start, center);
        int endQ = MathUtils.getQuadrant(end, center);
        if (endQ < startQ) {
            endQ += 4;
        }
        while (endQ > startQ) {
            switch (startQ) {
                case 0: {
                    bounds.addToBounds(center.getX(), center.getY() + this.radius, center.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(center.getX() - this.radius, center.getY(), center.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(center.getX(), center.getY() - this.radius, center.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(center.getX() + this.radius, center.getY(), center.getZ());
                    endQ -= 4;
                    startQ -= 4;
                }
            }
            ++startQ;
        }
        return bounds;
    }

    public void setCenterPoint(Point p) {
        this.center = p;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Point getStartPoint() {
        double angle = this.start_angle;
        return this.getPointAt(angle);
    }

    public Point getEndPoint() {
        double angle = this.end_angle;
        return this.getPointAt(angle);
    }

    public Point getPointAt(double angle) {
        double x = this.radius * Math.cos(Math.toRadians(angle));
        double y = this.radius * Math.sin(Math.toRadians(angle));
        ParametricPlane plane = new ParametricPlane(this.getExtrusion());
        Point p = plane.getPoint(x + this.center.getX(), y + this.center.getY());
        return p;
    }

    public String getType() {
        return "ARC";
    }

    public double getLength() {
        double alpha = this.getTotalAngle();
        return alpha * Math.PI * this.radius / 180.0;
    }

    public double getTotalAngle() {
        if (this.end_angle < this.start_angle) {
            return 360.0 + this.end_angle - this.start_angle;
        }
        return Math.abs(this.end_angle - this.start_angle);
    }

    public double getChordLength() {
        double s = 2.0 * this.radius * Math.sin(Math.toRadians(this.getTotalAngle() / 2.0));
        return s;
    }

    public boolean isCounterClockwise() {
        return this.counterclockwise;
    }

    public void setCounterClockwise(boolean counterclockwise) {
        this.counterclockwise = counterclockwise;
    }
}

