/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.helpers.Point;

public class Bounds {
    protected double max_x = Double.NEGATIVE_INFINITY;
    protected double min_x = Double.POSITIVE_INFINITY;
    protected double max_y = Double.NEGATIVE_INFINITY;
    protected double min_y = Double.POSITIVE_INFINITY;
    protected double max_z = Double.NEGATIVE_INFINITY;
    protected double min_z = Double.POSITIVE_INFINITY;
    protected boolean set = true;

    public Bounds() {
    }

    public Bounds(double max_x, double min_x, double max_y, double min_y, double max_z, double min_z) {
        this.max_x = max_x;
        this.min_x = min_x;
        this.max_y = max_y;
        this.min_y = min_y;
        this.max_z = max_z;
        this.min_z = min_z;
    }

    public Bounds(double max_x, double min_x, double max_y, double min_y) {
        this.max_x = max_x;
        this.min_x = min_x;
        this.max_y = max_y;
        this.min_y = min_y;
    }

    public Bounds(Bounds b) {
        this.max_x = b.getMaximumX();
        this.min_x = b.getMinimumX();
        this.max_y = b.getMaximumY();
        this.min_y = b.getMinimumY();
        this.max_z = b.getMaximumZ();
        this.min_z = b.getMinimumZ();
    }

    public double getMaximumX() {
        return this.max_x;
    }

    public void setMaximumX(double max_x) {
        this.max_x = max_x;
    }

    public double getMaximumY() {
        return this.max_y;
    }

    public void setMaximumY(double max_y) {
        this.max_y = max_y;
    }

    public double getMinimumX() {
        return this.min_x;
    }

    public void setMinimumX(double min_x) {
        this.min_x = min_x;
    }

    public double getMinimumY() {
        return this.min_y;
    }

    public void setMinimumY(double min_y) {
        this.min_y = min_y;
    }

    public double getMinimumZ() {
        return this.min_z;
    }

    public void setMinimumZ(double min_z) {
        this.min_z = min_z;
    }

    public double getMaximumZ() {
        return this.max_z;
    }

    public void setMaximumZ(double max_z) {
        this.max_z = max_z;
    }

    public double getCenterX() {
        return this.getMinimumX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getMinimumY() + this.getHeight() / 2.0;
    }

    public double getCenterZ() {
        return this.getMinimumZ() + this.getDepth() / 2.0;
    }

    public void addToBounds(Bounds bounds) {
        if (bounds.getMaximumX() > this.getMaximumX()) {
            this.setMaximumX(bounds.getMaximumX());
        }
        if (bounds.getMaximumY() > this.getMaximumY()) {
            this.setMaximumY(bounds.getMaximumY());
        }
        if (bounds.getMaximumZ() > this.getMaximumZ()) {
            this.setMaximumZ(bounds.getMaximumZ());
        }
        if (bounds.getMinimumX() < this.getMinimumX()) {
            this.setMinimumX(bounds.getMinimumX());
        }
        if (bounds.getMinimumY() < this.getMinimumY()) {
            this.setMinimumY(bounds.getMinimumY());
        }
        if (bounds.getMinimumZ() < this.getMinimumZ()) {
            this.setMinimumZ(bounds.getMinimumZ());
        }
    }

    public void addToBounds(double x, double y, double z) {
        if (x > this.getMaximumX()) {
            this.setMaximumX(x);
        }
        if (x < this.getMinimumX()) {
            this.setMinimumX(x);
        }
        if (y > this.getMaximumY()) {
            this.setMaximumY(y);
        }
        if (y < this.getMinimumY()) {
            this.setMinimumY(y);
        }
        if (z < this.getMinimumZ()) {
            this.setMinimumZ(z);
        }
        if (z > this.getMaximumZ()) {
            this.setMaximumZ(z);
        }
    }

    public void addToBounds(Point p) {
        this.addToBounds(p.getX(), p.getY(), p.getZ());
    }

    public double getWidth() {
        return Math.abs(this.getMaximumX() - this.getMinimumX());
    }

    public double getHeight() {
        return Math.abs(this.getMaximumY() - this.getMinimumY());
    }

    public double getDepth() {
        return Math.abs(this.getMaximumZ() - this.getMinimumZ());
    }

    public boolean isValid() {
        if (this.max_x == Double.NEGATIVE_INFINITY || this.max_y == Double.NEGATIVE_INFINITY || this.min_x == Double.POSITIVE_INFINITY || this.min_y == Double.POSITIVE_INFINITY) {
            return false;
        }
        return this.set;
    }

    public void setValid(boolean set) {
        this.set = set;
    }

    public void debug() {
        System.out.println("DEBUG Bounds");
        System.out.println("MAX_x=" + this.max_x);
        System.out.println("MAX_y=" + this.max_y);
        System.out.println("MIN_x=" + this.min_x);
        System.out.println("MIN_y=" + this.min_y);
        System.out.println("Width=" + this.getWidth() + " Height:" + this.getHeight());
    }

    public boolean contains(Bounds bounds) {
        if (bounds.getMaximumX() <= this.min_x || bounds.getMinimumX() >= this.max_x) {
            return false;
        }
        return !(bounds.getMaximumY() <= this.min_y) && !(bounds.getMinimumY() >= this.max_y);
    }

    public boolean contains(Point p) {
        return this.min_x <= p.getX() && this.max_x >= p.getX() && this.min_y <= p.getY() && this.max_y >= p.getY();
    }

    public boolean enclose(Bounds bounds) {
        return bounds.getMaximumX() <= this.max_x && bounds.getMinimumX() >= this.min_x && bounds.getMaximumY() <= this.max_y && bounds.getMinimumY() >= this.min_y;
    }
}

