/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;
import org.kabeja.processing.ProcessPipeline;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.tools.SAXProcessingManagerBuilder;
import org.kabeja.ui.impl.ServiceContainer;
import org.kabeja.ui.xml.SAXServiceContainerBuilder;

public class Main {
    private String encoding = "";
    private String sourceFile;
    private String destinationFile;
    private Parser parser;
    private boolean process = false;
    private boolean directoryMode = true;
    private ProcessingManager processorManager;
    private String pipeline;
    private boolean nogui = false;

    public static void main(String[] args) {
        Main main = new Main();
        int i = 0;
        boolean source = true;
        boolean help = false;
        while (i < args.length) {
            if (args[i].equals("-pp")) {
                try {
                    main.setProcessConfig(new FileInputStream(args[i + 1]));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                i += 2;
                continue;
            }
            if (args[i].equals("-pipeline")) {
                main.setPipeline(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equals("--help")) {
                ++i;
                help = true;
                continue;
            }
            if (args[i].equals("-nogui")) {
                main.omitUI(true);
                ++i;
                continue;
            }
            if (source) {
                main.setSourceFile(args[i]);
                source = false;
                ++i;
                continue;
            }
            main.setDestinationFile(args[i]);
            ++i;
        }
        main.initialize();
        if (help || args.length == 1 && main.isNogui()) {
            Main.printUsage();
            main.printPipelines();
        } else {
            main.process();
        }
    }

    private static void printUsage() {
        System.out.println("\n Use: java -jar kabeja.jar <Options> sourcefile  <outputfile>\n\nOptions:\n  --help shows this and exit\n  -nogui run only the cli, omit the user interface\n  -pp process.xml set processing file to use\n  -pipeline name  process the given pipeline\n\nIf the source is a directory, all containing files will be converted.\n");
    }

    public void initialize() {
        if (this.processorManager == null) {
            this.setProcessConfig(this.getClass().getResourceAsStream("/conf/process.xml"));
        }
    }

    public void process() {
        if (this.parser == null) {
            this.parser = ParserBuilder.createDefaultParser();
        }
        if (this.nogui) {
            File f = new File(this.sourceFile);
            if (f.exists() && f.isFile()) {
                this.parseFile(f, this.destinationFile);
            } else if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().toLowerCase().endsWith(".dxf")) continue;
                    try {
                        String source = files[i].getCanonicalPath();
                        String extension = null;
                        String result = source.substring(0, source.toLowerCase().lastIndexOf(".dxf")) + extension;
                        System.out.println("convert file:" + source);
                        this.parseFile(files[i], result);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Cannot open " + this.sourceFile);
            }
        } else {
            try {
                ServiceContainer sc = SAXServiceContainerBuilder.buildFromStream(new FileInputStream("conf/ui.xml"));
                sc.setProcessingManager(this.processorManager);
                sc.start();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(String destinationFile) {
        this.destinationFile = destinationFile;
        this.directoryMode = false;
    }

    private void parseFile(File f, String output) {
        try {
            this.parser.parse(new FileInputStream(f), this.encoding);
            DXFDocument doc = this.parser.getDocument();
            if (this.process) {
                if (this.directoryMode) {
                    this.processorManager.process(doc, new HashMap(), this.pipeline, f.getAbsolutePath());
                } else {
                    this.processorManager.process(doc, new HashMap(), this.pipeline, new FileOutputStream(output));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setParserConfigFile(String file) {
        this.parser = ParserBuilder.buildFromXML(file);
    }

    public void setProcessConfig(InputStream in) {
        this.processorManager = SAXProcessingManagerBuilder.buildFromStream(in);
    }

    public void setPipeline(String name) {
        this.pipeline = name;
        this.process = true;
    }

    public void omitUI(boolean b) {
        this.nogui = b;
    }

    public void printPipelines() {
        Iterator i = this.processorManager.getProcessPipelines().keySet().iterator();
        System.out.println("\n Available pipelines:\n----------\n");
        while (i.hasNext()) {
            String pipeline = (String)i.next();
            ProcessPipeline pp = this.processorManager.getProcessPipeline(pipeline);
            System.out.print(" " + pipeline);
            if (pp.getDescription().length() > 0) {
                System.out.print("\t" + pp.getDescription());
            }
            System.out.println();
        }
    }

    public boolean isNogui() {
        return this.nogui;
    }
}

