/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.ObjectFactory;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TableInfo<T, ID> {
    private static final FieldType[] NO_FOREIGN_COLLECTIONS = new FieldType[0];
    private final BaseDaoImpl<T, ID> baseDaoImpl;
    private final Class<T> dataClass;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType[] foreignCollections;
    private final FieldType idField;
    private final Constructor<T> constructor;
    private final boolean foreignAutoCreate;
    private Map<String, FieldType> fieldNameMap;

    public TableInfo(ConnectionSource connectionSource, BaseDaoImpl<T, ID> baseDaoImpl, Class<T> dataClass) throws SQLException {
        this(connectionSource.getDatabaseType(), baseDaoImpl, DatabaseTableConfig.fromClass(connectionSource, dataClass));
    }

    public TableInfo(DatabaseType databaseType, BaseDaoImpl<T, ID> baseDaoImpl, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.baseDaoImpl = baseDaoImpl;
        this.dataClass = tableConfig.getDataClass();
        this.tableName = tableConfig.getTableName();
        this.fieldTypes = tableConfig.getFieldTypes(databaseType);
        FieldType findIdFieldType = null;
        boolean foreignAutoCreate = false;
        int foreignCollectionCount = 0;
        for (FieldType fieldType : this.fieldTypes) {
            if (fieldType.isId() || fieldType.isGeneratedId() || fieldType.isGeneratedIdSequence()) {
                if (findIdFieldType != null) {
                    throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
                }
                findIdFieldType = fieldType;
            }
            if (fieldType.isForeignAutoCreate()) {
                foreignAutoCreate = true;
            }
            if (!fieldType.isForeignCollection()) continue;
            ++foreignCollectionCount;
        }
        this.idField = findIdFieldType;
        this.constructor = tableConfig.getConstructor();
        this.foreignAutoCreate = foreignAutoCreate;
        if (foreignCollectionCount == 0) {
            this.foreignCollections = NO_FOREIGN_COLLECTIONS;
        } else {
            this.foreignCollections = new FieldType[foreignCollectionCount];
            foreignCollectionCount = 0;
            for (FieldType fieldType : this.fieldTypes) {
                if (!fieldType.isForeignCollection()) continue;
                this.foreignCollections[foreignCollectionCount] = fieldType;
                ++foreignCollectionCount;
            }
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String columnName) {
        FieldType fieldType;
        if (this.fieldNameMap == null) {
            HashMap<String, FieldType> map = new HashMap<String, FieldType>();
            for (FieldType fieldType2 : this.fieldTypes) {
                map.put(fieldType2.getColumnName().toLowerCase(), fieldType2);
            }
            this.fieldNameMap = map;
        }
        if ((fieldType = this.fieldNameMap.get(columnName.toLowerCase())) != null) {
            return fieldType;
        }
        for (FieldType fieldType2 : this.fieldTypes) {
            if (!fieldType2.getFieldName().equals(columnName)) continue;
            throw new IllegalArgumentException("You should use columnName '" + fieldType2.getColumnName() + "' for table " + this.tableName + " instead of fieldName '" + fieldType2.getFieldName() + "'");
        }
        throw new IllegalArgumentException("Unknown column name '" + columnName + "' in table " + this.tableName);
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public String objectToString(T object) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(object.getClass().getSimpleName());
        for (FieldType fieldType : this.fieldTypes) {
            sb.append(' ').append(fieldType.getColumnName()).append('=');
            try {
                sb.append(fieldType.extractJavaFieldValue(object));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not generate toString of field " + fieldType, e);
            }
        }
        return sb.toString();
    }

    public T createObject() throws SQLException {
        try {
            ObjectFactory<T> factory = null;
            if (this.baseDaoImpl != null) {
                factory = this.baseDaoImpl.getObjectFactory();
            }
            T instance = factory == null ? this.constructor.newInstance(new Object[0]) : factory.createObject(this.constructor, this.baseDaoImpl.getDataClass());
            TableInfo.wireNewInstance(this.baseDaoImpl, instance);
            return instance;
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not create object for " + this.constructor.getDeclaringClass(), e);
        }
    }

    public boolean isUpdatable() {
        return this.idField != null && this.fieldTypes.length > 1;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public FieldType[] getForeignCollections() {
        return this.foreignCollections;
    }

    public boolean hasColumnName(String columnName) {
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    private static <T, ID> void wireNewInstance(BaseDaoImpl<T, ID> baseDaoImpl, T instance) {
        if (instance instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)instance;
            daoEnabled.setDao(baseDaoImpl);
        }
    }
}

