/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.BaseFieldConverter;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.List;

public class SqlServerDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "sqlserver";
    private static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DATABASE_NAME = "SQL Server";
    private static final FieldConverter byteConverter = new ByteFieldConverter();
    private static final FieldConverter booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public FieldConverter getFieldConverter(DataPersister dataType, FieldType fieldType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
            case BYTE: {
                return byteConverter;
            }
        }
        return super.getFieldConverter(dataType, fieldType);
    }

    protected void appendUuidNativeType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("UNIQUEIDENTIFIER");
    }

    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BIT");
    }

    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DATETIME");
    }

    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        if (fieldType.isAllowGeneratedIdInsert()) {
            StringBuilder identityInsertSb = new StringBuilder();
            identityInsertSb.append("SET IDENTITY_INSERT ");
            this.appendEscapedEntityName(identityInsertSb, tableName);
            identityInsertSb.append(" ON");
            statementsAfter.add(identityInsertSb.toString());
        }
    }

    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    public boolean isLimitAfterSelect() {
        return true;
    }

    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("TOP ").append(limit).append(' ');
    }

    public boolean isOffsetSqlSupported() {
        return false;
    }

    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    public boolean isCreateTableReturnsNegative() {
        return true;
    }

    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }

    public boolean isTruncateSupported() {
        return true;
    }

    private static class ByteFieldConverter
    extends BaseFieldConverter {
        private ByteFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BYTE;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getShort(columnPos);
        }

        public Object sqlArgToJava(FieldType fieldType, Object sqlObject, int columnPos) {
            short shortVal = (Short)sqlObject;
            if (shortVal < -128) {
                return (byte)-128;
            }
            if (shortVal > 127) {
                return (byte)127;
            }
            return (byte)shortVal;
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            byte byteVal = (Byte)javaObject;
            return (short)byteVal;
        }

        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Short.parseShort(stringValue), columnPos);
        }
    }
}

